//
// Copyright (c) 2002
// Ronald Kevin Burton
//
// Z poniszym kodem nie jest zwizana adna gwarancja poprawnoci dziaania.
// Program zosta doczony do ksiki ".NET CLR. Ksiga eksperta" w celu
// ilustracji koncepcji i zasad przedstawionych w tej ksice. Program moe by 
// uywany na wasne ryzyko.
//
// Przyznaje si prawo do uycia lub kopiowania tego oprogramowania do dowolnego celu
// bez koniecznoci ponoszenia adnych opat pod warunkiem, e powysze uwagi zostan 
// zachowane we wszystkich kopiach. Przyznaje si take prawo do modyfikacji kodu
// i dystrybucji zmodyfikowanego kodu pod warunkiem zachowania powyszych uwag
// oraz doczenia informacji mwicej o modyfikacji kodu.
//
// 
using System;
using System.Text;
using System.IO;
using System.Net;
using System.Net.Sockets;

class Sender
{

	public static void Main(string[] args)
	{	
		string address = "localhost";
		if(args.Length == 1)
			address = args[0];

		SendMessage(address);
	}

	public static Socket GetSocket(string host, int port) 
	{
		Socket s = null;
		IPHostEntry iphe = Dns.Resolve(host);
		// Ptla dla wszystkich adresw, a nie tylko
		// pierwszy adres.  
		foreach(IPAddress ipa in iphe.AddressList) 
		{
			IPEndPoint ipe = new IPEndPoint(ipa, port);
		
			// Uycie AddressFamily, ktra stanowi cz
			// punktu kocowego. 
			// AddressFamily.InterNetwork ogranicza
			// do IPv4.
			Socket ts = new Socket(ipe.AddressFamily,
				                   SocketType.Stream,
				                   ProtocolType.Tcp);
			try 
			{
				// Zwrcenie pierwszego gniazda, 
				// z ktrym mona nawiza poczenie.
				ts.Connect(ipe);
				s = ts;
				break;
			} 
			catch (ArgumentNullException ae)
			{
				Console.WriteLine("Wyjtek ArgumentNullException: " + ae.ToString());
			}
			catch (SocketException se)
			{				
				Console.WriteLine("Wyjtek SocketException: " + se.ToString());
			}
			catch (Exception e) 
			{
				Console.WriteLine("Poczenie nie powiodo si: " + e.ToString());
			}
		}
		return s;
	}

	public static void SendMessage(string server)
	{
		Socket s = GetSocket(server, 5000);
		if(s == null)
			return;
		bool continueSending = true;
		while(continueSending)
		{		
			Console.WriteLine("Wprowad wiadomo do wysania. Wpisz 'quit', aby wyj.");
			string message = Console.ReadLine();
			// byte[] buffer = Encoding.ASCII.GetBytes(message);
			byte[] buffer = Encoding.Unicode.GetBytes(message);
			// Ponisze polecenie wysya cay bufor.
			s.Send(buffer);													
			if(message == "quit")
			{
				continueSending = false;
			}	
		}
		s.Close();
	}
}
